/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;

public class BlockWeightedRandom
implements BlockBrush {
    private WeightedRandomizer<BlockBrush> blocks = new WeightedRandomizer();

    public BlockWeightedRandom() {
    }

    public BlockWeightedRandom(JsonElement data) {
        for (JsonElement jsonElement : (JsonArray)data) {
            if (jsonElement.isJsonNull()) continue;
            JsonObject d = jsonElement.getAsJsonObject();
            int weight = d.get("weight").getAsInt();
            BlockBrush toAdd = BlockProvider.create(d);
            this.addBlock(toAdd, weight);
        }
    }

    public BlockWeightedRandom(WeightedRandomizer<BlockBrush> blocks) {
        this.blocks = blocks;
    }

    public void addBlock(BlockBrush toAdd, int weight) {
        this.blocks.add(new WeightedChoice<BlockBrush>(toAdd, weight));
    }

    @Override
    public boolean stroke(WorldEditor editor, Coord origin, boolean fillAir, boolean replaceSolid) {
        BlockBrush block = this.blocks.get(editor.getRandom());
        return block.stroke(editor, origin, fillAir, replaceSolid);
    }

    @Override
    public BlockWeightedRandom copy() {
        return new BlockWeightedRandom(this.blocks.copy());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockWeightedRandom)) {
            return false;
        }
        BlockWeightedRandom other = (BlockWeightedRandom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WeightedRandomizer<BlockBrush> this$blocks = this.blocks;
        WeightedRandomizer<BlockBrush> other$blocks = other.blocks;
        return !(this$blocks == null ? other$blocks != null : !((Object)this$blocks).equals(other$blocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockWeightedRandom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WeightedRandomizer<BlockBrush> $blocks = this.blocks;
        result = result * 59 + ($blocks == null ? 43 : ((Object)$blocks).hashCode());
        return result;
    }

    public String toString() {
        return "BlockWeightedRandom(blocks=" + this.blocks + ")";
    }
}

